import java.awt.Panel;
import java.awt.Dimension;
import java.awt.Graphics; 
import java.awt.Rectangle;
import types.DataClass;

public class WheelPanel extends Panel {
    int m_iSizeX;
    int m_iSizeY;
    DataClass m_Data;
    public WheelPanel(DataClass data,int iSizeX,int iSizeY) {
        m_Data = data;
        m_iSizeX = iSizeX;
        m_iSizeY = iSizeY;
    }
    public void paint(Graphics g) {
        Wheel wheel = new Wheel(m_Data);
        wheel.paint(g,new Rectangle(0,0,m_iSizeX,m_iSizeY));
    };
    public void myUpdate(DataClass data) {
        m_Data = data;
        repaint();
    }
    public Dimension preferredSize() {
        return (new Dimension(m_iSizeX+1,m_iSizeY+1));
    };
    public Dimension minimumSize() {
        return (new Dimension(m_iSizeX+1,m_iSizeY+1));
    };
}


